﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;

public struct HidableMetadata
{
    public GameObject GameObject { get; private set; }  //The hidable game object
    public HidableController Controller { get; private set; }   //The hidable controller attached to the game object

    public HidableMetadata(GameObject obj, HidableController controller)
    {
        GameObject = obj;
        Controller = controller;
    }
}

public class HidablesManager : MonoBehaviour
{
    public Dictionary<string, HidableMetadata> HidableGameObjects { get; private set; } //A dictionary of hidable game objects. Key - tile name. Value - metadata.

    private static HidablesManager _Instance;
    public static HidablesManager Instance
    {
        get
        {
            if (_Instance == null)
            {
                _Instance = FindObjectOfType<HidablesManager>();
            }

            return _Instance;
        }
    }

    private void Start()
    {
        HidableGameObjects = ParsePrefabsFolder();
    }

    /// <summary>
    /// Parses the prefabs resources folder to get the dictionary of hidables
    /// </summary>
    /// <returns></returns>
    private Dictionary<string, HidableMetadata> ParsePrefabsFolder()
    {
        Dictionary<string, HidableMetadata> retDict = new Dictionary<string, HidableMetadata>();

        UnityEngine.Object[] objects = Resources.LoadAll("Prefabs", typeof(GameObject));    //Get all the hidable prefab resources

        foreach(GameObject obj in objects)
        {
            if(obj.tag == Constants.HidableTag)
            {
                //This prefab is definitely a hidable
                if (obj.GetComponent<HidableController>() != null)
                {
                    //Get the controller, add to the dictionary
                    HidableController controller = obj.GetComponent<HidableController>();
                    retDict.Add(controller.SpawnTileSprite.name, new HidableMetadata(obj, controller));
                }

                else
                {
                    Debug.Log(obj.name + " does not have a HidableController attached!");
                }
            }
        }
        
        return retDict;
    }
}
